<?php get_header() ?>


<section class="head">  
    <div class="body">
       <video class="hearo-video" width="100%" loop="" autoplay="" muted="" playsinline="">
            <source src="<?php the_field('head', 'option'); ?>" type="video/mp4">
        </video>

    <div class="cavers">
        <div class="tit">
            <span>
                <strong>Product details</strong>
            </span>
        </div>
    </div>
    </div>
</section>






<section class="partners pro-page">
    <div class="container">
        <div class="all col-12">

          <div class="block col-12 col-md-7">
            <img src="<?php the_post_thumbnail_url(); ?>" alt=""> 
          </div>

          <div class="block block-text col-12 col-md-5">
             <?php if(have_posts()) : ?>
            <?php while(have_posts()) : the_post(); ?>
            <h1> <?php the_title() ?></h1>

             <?php if ( function_exists("has_post_thumbnail") && has_post_thumbnail() ) : ?>
                  <?php endif; ?>
                  <?php $content = get_the_content();
                  $content = strip_tags($content);
                  echo mb_substr($content,0,99999999,"UTF8");?>

                  <div class="boxpru col-12">
                    <h3>Price</h3>
                    <div>Cost for 1 investor</div>


   <?php
global $product;

// السعر كرقم + التنسيق
$price = $product->get_price(); // رقم فقط
$formatted = wc_price($price); // سعر منسق مع العملة

// استخراج الرقم والعملة من السعر المنسق
preg_match('/([\d\.,]+)\s*(.*)/u', strip_tags($formatted), $matches);

$number = $matches[1];    // السعر كـ نص
$currency = $matches[2];  // العملة
?>

<!-- كمية + زر الإضافة -->
<div class="qty">
  <form class="cart quantity-with-buttons" method="post" enctype="multipart/form-data">
<div>
  <!-- السعر والعملة -->
  <span class="price-currency">OMR</span>
  <span class="price-number"><?php echo $number; ?></span>
</div>


    <?php
      woocommerce_quantity_input(array(
        'min_value'   => $product->get_min_purchase_quantity(),
        'max_value'   => $product->get_max_purchase_quantity(),
        'input_value' => 1,
      ), $product);
    ?>
    <button type="submit" name="add-to-cart" value="<?php echo esc_attr($product->get_id()); ?>" class="col-12 single_add_to_cart_button button alt">
      <?php // echo esc_html($product->single_add_to_cart_text()); ?>
      Book The Service
    </button>
  </form>
</div>

<!-- تمرير السعر كمتغير نظيف إلى JS -->
<script>
  const unitPrice = parseFloat("<?php echo str_replace(',', '', $number); ?>");
</script>

<!-- JS: أزرار + و - -->
<script>
document.addEventListener('DOMContentLoaded', function () {
  const quantityWrappers = document.querySelectorAll('.quantity');

  quantityWrappers.forEach(function (wrapper) {
    const input = wrapper.querySelector('input.qty');

    const minusBtn = document.createElement('div');
    minusBtn.className = 'quantity-button minus';
    minusBtn.textContent = '−';

    const plusBtn = document.createElement('div');
    plusBtn.className = 'quantity-button plus';
    plusBtn.textContent = '+';

    wrapper.prepend(minusBtn);
    wrapper.appendChild(plusBtn);

    minusBtn.addEventListener('click', function () {
      let current = parseFloat(input.value);
      let min = parseFloat(input.min) || 1;
      if (current > min) {
        input.value = current - 1;
        input.dispatchEvent(new Event('input'));
      }
    });

    plusBtn.addEventListener('click', function () {
      let current = parseFloat(input.value);
      let max = parseFloat(input.max) || 999;
      if (current < max) {
        input.value = current + 1;
        input.dispatchEvent(new Event('input'));
      }
    });
  });
});
</script>

<!-- JS: تحديث السعر تلقائي -->
<script>
document.addEventListener('DOMContentLoaded', function () {
  const qtyInput = document.querySelector('input.qty');
  const priceDisplay = document.querySelector('.price-number');

  if (!qtyInput || !priceDisplay || isNaN(unitPrice)) return;

  function updatePrice() {
    const qty = parseFloat(qtyInput.value) || 1;
    const total = (unitPrice * qty).toFixed(2);
    priceDisplay.textContent = total.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
  }

  qtyInput.addEventListener('input', updatePrice);
  updatePrice(); // تحديث مبدأي
});
</script>
                 

</div>

                  </div>

            <?php endwhile; ?>
            <?php else : ?>
          <?php endif; ?>  
          </div>
          
        </div>
    </div>
</section>






<section class="info">
    <div class="container">
      <div class="block block-text col-12 col-md-6">
        <h2>Required Documents</h2>
        <p>Please prepare these documents</p>

        <?php echo $product->get_short_description();?>
      </div>
      <div class="block col-12 col-md-6">
        <h2 class="book">Book the Service</h2>
        <?php echo do_shortcode('[woocommerce_checkout]'); ?>
      </div>
    </div>
</section>



<?php get_footer() ?>